<?php
/*--------------------------------------------------------------------
 ReadService.php 2020-2-17
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\SellingUnit\Database\Price\PropertyInformation\Service;

use Gambio\Shop\Product\ValueObjects\ProductId;
use Gambio\Shop\SellingUnit\Database\Price\PropertyInformation\Repository\DTO\CombisIdDtoCollection;
use Gambio\Shop\SellingUnit\Database\Price\PropertyInformation\Repository\RepositoryInterface;

/**
 * Class ReadService
 * @package Gambio\Shop\SellingUnit\Database\Price\PropertyInformation\Service
 */
class ReadService implements ReadServiceInterface
{
    /**
     * @var RepositoryInterface
     */
    protected $repository;
    
    
    /**
     * ReadService constructor.
     *
     * @param RepositoryInterface $repository
     */
    public function __construct(RepositoryInterface $repository)
    {
        $this->repository = $repository;
    }
    
    
    /**
     * @inheritDoc
     */
    public function availableCombisIds(ProductId $productId): CombisIdDtoCollection
    {
        return $this->repository->availableCombisIds($productId);
    }
}